# Teardown Pattern Library (8 SaaS Patterns)

Use this for inspiration before drafting, or for improving v2 after launch.  
If you’re unsure how to structure your page, run 1–2 teardowns first using the template at the bottom.

---
## Pattern 1: One-line category definition + concrete outcome
Hero defines category + job-to-be-done immediately.

## Pattern 2: Trust strip right under hero
Logos/user counts/quotes reduce bounce quickly.

## Pattern 3: Old way vs new way framing
Comparison makes pain and improvement obvious.

## Pattern 4: 3-step “How it works”
Reduces complexity fear and supports trial/demo clicks.

## Pattern 5: Feature blocks tied to outcomes
Each feature includes an explicit user outcome + proof.

## Pattern 6: Pricing with clear plan intent
Each tier clearly states “best for whom.”

## Pattern 7: FAQ that removes final anxieties
Handles setup, migration, security, and billing concerns.

## Pattern 8: Closing CTA that restates value
Repeats core outcome and next step; no new concepts.

---
## Teardown Annotation Template

- Product/category:
- Primary ICP:
- Above-the-fold clarity score (1–5):
- Strongest section:
- Weakest section:
- Best copy move to borrow:
- Biggest gap to avoid:
- How to adapt for my SaaS:
