# Review & Checklist System

Use this system before launch and after each major landing page update.

## Start Here: Minimal v1 Checks (must-pass)
If you’re shipping fast, pass these first:
- [ ] Above fold clearly says what product does, for whom, and why it matters.
- [ ] Primary CTA is obvious and appears above fold.
- [ ] Pricing + FAQ address top objections.
- [ ] Page is readable and tappable on mobile.

If these four pass, launch and iterate.

---
## 1) Full Pre-Launch Checklist (Founder)

### A. Clarity (**MUST-PASS**)
- [ ] Above fold clearly states what product does.
- [ ] ICP is obvious (“for whom” is explicit).
- [ ] Primary outcome is concrete (not generic “streamline”).
- [ ] CTA label is specific (Start trial / Book demo / etc.).

### B. Messaging Quality (**MUST-PASS for core sections**)
- [ ] Headline and subhead are plain-English, not jargon-heavy.
- [ ] Every major feature includes an explicit user benefit.
- [ ] At least one proof element exists (logo, quote, metric, demo visual).
- [ ] Pricing section explains who each plan is for.

### C. UX & Flow (**NICE-TO-HAVE, but strongly recommended**)
- [ ] Navigation is simple; no dead links.
- [ ] Section order follows logic (clarity → trust → mechanism → price → FAQ).
- [ ] CTA appears at least 3 times through page.
- [ ] Page is scannable (short blocks, clear headings).

### D. Mobile Checks (**MUST-PASS**)
- [ ] Hero headline and CTA visible without awkward wrapping.
- [ ] Buttons are tap-friendly.
- [ ] Pricing cards and tables are readable.
- [ ] No visual overlap/cutoff in screenshots.

### E. Performance Basics (**NICE-TO-HAVE for v1, MUST for scale**)
- [ ] Large images compressed.
- [ ] No obviously broken scripts/widgets.
- [ ] Core page loads quickly on standard mobile connection.

---
## 2) Peer Review Guide (Friend/Advisor)

Ask reviewer to scroll once without context. Then ask:
1. In one sentence, what do you think this product does?
2. Who do you think it’s for?
3. What made you trust it (or not)?
4. What felt vague/confusing?
5. What was the most compelling section?
6. What objections do you still have?
7. If you were interested, what would you click?
8. What nearly stopped you from continuing to read?

---
## 3) Iteration Worksheet

### Version Log
- Version/date:
- Traffic source (if known):
- Primary CTA used:
- Primary metric tracked (trial signup/demo request):

### Feedback Summary
- Top 3 confusion points:
1.
2.
3.

- Top 3 positive signals:
1.
2.
3.

### Change Plan
- Change #1:
  - Hypothesis:
  - Section affected:
  - Success signal:
- Change #2:
  - Hypothesis:
  - Section affected:
  - Success signal:
- Change #3:
  - Hypothesis:
  - Section affected:
  - Success signal:

### Decision
- [ ] Ship unchanged
- [ ] Ship with minor edits
- [ ] Delay and revise major messaging

---
## 4) 30-Minute “Good Enough” Routine

1. 10 min: Above-fold clarity + CTA pass
2. 10 min: Pricing + FAQ objection pass
3. 10 min: Mobile scroll + broken links pass

If these pass, publish and iterate from real feedback.
