# Section Blueprints Library (12 Modules)

Each blueprint includes: goal, wireframe structure, copy prompts, and example snippets.

## Minimal v1 Path (Start Here)
If you want the least-overwhelming path, start with these 8 sections:
1) Hero + CTA  2) Problem  3) Solution  4) Feature→Benefit→Proof  
5) Social Proof  6) Pricing  7) FAQ  8) Final CTA

Then add Use Cases, Integrations, and Founder Credibility in v2.

---
## 1) Hero + Primary CTA
**Goal:** Explain what it does, for whom, and why now.

**Wireframe:**
- H1 headline
- 1–2 line subhead
- Primary CTA + secondary CTA
- Product visual (screenshot/demo loop)
- Optional trust micro-proof line

**Copy prompts:**
- [WHO] gets [OUTCOME] without [PAIN] using [PRODUCT].
- What is the one outcome in 30 days?
- What friction does your tool remove?

---
## 2) Social Proof Strip
**Goal:** Build trust quickly.

**Wireframe:**
- Logo row
- Optional metric chips
- 1 short testimonial card

---
## 3) Problem Narrative (Old Way vs New Way)
**Goal:** Make visitors feel seen.

**Wireframe:**
- Problem headline
- 2-column comparison
- Pain bullets → improved state bullets

---
## 4) Solution Overview (How it Works)
**Goal:** Reduce perceived complexity.

**Wireframe:**
- “How it works in 3 steps”
- Short labels + icons/mini diagrams
- One screenshot per step (optional)

---
## 5) Feature → Benefit → Proof Blocks
**Goal:** Turn feature list into buyer value.

**Wireframe:**
- Repeating cards or rows: feature title, one-line benefit, proof

---
## 6) Use Cases / Who It’s For
**Goal:** Help multiple ICPs self-identify.

**Wireframe:**
- 3 segmented cards (persona/use case)

---
## 7) Integrations / Ecosystem
**Goal:** Remove “will this fit my stack?” fear.

**Wireframe:**
- Integration logos grid
- One sentence on setup effort

---
## 8) Pricing Section
**Goal:** Clarify plans and reduce purchase anxiety.

**Wireframe:**
- 1–3 plan cards + risk reversal + CTA

---
## 9) Objection Handling Panel
**Goal:** Pre-answer conversion blockers.

**Wireframe:**
- 3–5 objection tiles with short answers

**When to use vs FAQ:**
If you’re tight on space, fold these into FAQ near pricing.  
If you have room, keep this as a separate section directly above pricing.

---
## 10) FAQ
**Goal:** Address edge-case concerns without cluttering main flow.

**Wireframe:**
- 6–10 accordion questions

---
## 11) Final CTA Section
**Goal:** Close with clear next step.

**Wireframe:**
- Restated outcome headline + one proof line + CTA

---
## 12) Founder Credibility / Team Note (Optional)
**Goal:** Add trust for very early-stage products.

Use when logos/testimonials are still thin.

---
## Blueprint Usage Rules
- Pick 8–10 sections for v1; avoid overbuilding.
- Prioritize clarity + proof over visual complexity.
- Every section must either increase understanding or increase trust.
