# Landing Structure Playbook (SaaS)

Use this playbook to assemble a complete landing page from modular sections. The system is stack-agnostic (Webflow, Framer, Notion site, coded, etc.).

> ## Start Here (v1 path)
> If you’re overwhelmed, pick **one** product variant below and follow only that order for v1.  
> Ignore the other variants until after launch.

---
## 1) Core Assembly Order (Default)

Use this baseline order for most early-stage SaaS pages:

1. Hero + Primary CTA  
2. Social Proof / Credibility Strip  
3. Problem Narrative (old way vs new way)  
4. Solution Overview (how it works)  
5. Feature → Outcome Blocks  
6. Use Cases / Who It’s For  
7. Integrations / Ecosystem (optional if relevant)  
8. Pricing + Risk Reversal  
9. FAQ  
10. Final CTA

**Why this order works:** It moves from clarity → trust → mechanism → evidence → action.

---
## 2) Variant: Single-Feature MVP

Best for simple products with one core job-to-be-done.

Recommended flow:
1. Hero (one bold promise)  
2. Problem narrative  
3. Product screenshot + “how it works in 3 steps”  
4. Feature/outcome trio  
5. Social proof (beta quotes okay)  
6. Pricing (one plan + annual toggle optional)  
7. FAQ  
8. Final CTA

**Copy rule:** keep language plain and concrete; avoid “platform” language.

---
## 3) Variant: Multi-Feature Platform

Best when product has modules/workspaces/roles.

Recommended flow:
1. Hero (umbrella outcome)  
2. Credibility strip (logos, customer types, stats)  
3. Use-case segmentation (by role/team/use case)  
4. Module overview grid  
5. Deeper feature→outcome blocks  
6. Integrations  
7. Pricing table (2–3 tiers)  
8. FAQ (implementation/security/integration concerns)  
9. Final CTA

**Copy rule:** sell outcomes first, then modules. Never lead with architecture diagrams.

---
## 4) Variant: AI SaaS / Dev Tool

Best for API tools, copilots, automation, and technical products.

Recommended flow:
1. Hero (specific technical audience + outcome)  
2. “Built for [persona]” proof (benchmarks, speed, reliability, usage)  
3. Before/after workflow comparison  
4. Feature→benefit blocks with technical proof  
5. Integrations/API ecosystem  
6. Security/reliability trust section  
7. Pricing (free trial / usage tiers)  
8. FAQ (data handling, limits, onboarding)  
9. Final CTA

**Copy rule:** use concrete capability + proof, not generic “AI-powered” claims.

---
## 5) Minimum Viable Sections for v1 (Use this if short on time)

If you only have one weekend, build these 8 sections first:

1. Hero + CTA
2. Problem narrative
3. Solution overview
4. Feature → benefit → proof blocks
5. Social proof
6. Pricing
7. FAQ
8. Final CTA

Add use cases/integrations/extra trust pages later.

---
## 6) CTA Strategy by Motion

### Self-serve / trial motion
Primary CTA examples:
- Start free trial
- Try it free
- Create workspace

Secondary CTA examples:
- See demo
- View sample project

### Sales-led / demo motion
Primary CTA examples:
- Book a demo
- Talk to sales
- See it in action

Secondary CTA examples:
- Watch 2-min walkthrough
- View pricing

**Placement minimum:** one CTA above fold, one after feature section, one at close.

---
## 7) “Good Enough to Launch” Standard

Launch when these are true:
- A new visitor can explain what you do in <10 seconds.
- CTA and next step are obvious on first screen.
- Core objections are addressed in pricing + FAQ.
- Mobile version is readable and tappable.

Then iterate weekly using the review worksheet.
